#include <stdio.h>
#include <string.h>
#include <vga.h>
#include <vgagl.h>
#include "hangul.h"

void or_image(byte *s1, byte *s2, int len) {
	do *s1++ |= *s2++; while (--len);
}

void *get_han_image(byte first, byte second) {
	unsigned h1, h2, h3, type1, type2, type3;
  static byte ib[32];
	static byte index1[]= {
		0,  0,  1,  2,  3,  4,  5,  6,
		7,  8,  9,  10, 11, 12, 13, 14,
		15, 16, 17, 18, 19,  0,  0,  0,
		0,  0,   0,  0,  0,  0,  0,  0
	  };
	static byte index2[]= {
		0,  0,  0,  1,  2,  3,  4,  5,
		0,  0,  6,  7,  8,  9,  10, 11,
		0,  0, 12, 13, 14, 15,  16, 17,
		0,  0, 18, 19, 20, 21,   0,  0
		};
	static byte index3[]= {
		0,  0,  1,  2,  3,  4,  5,  6,
		7,  8,  9, 10, 11, 12,  13, 14,
		15, 16, 0, 17, 18, 19,  20, 21,
		22, 23, 24, 25, 26, 27,  0,  0
		};
  static byte type1_no[]= {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3,
		3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0
		};
	static byte type1_yes[]= {
		5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7,
		7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5,
		};
	static byte _type3[]= {
		0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0,
		2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1
		};

  h1= (first & 0x7f) >> 2;
	h2= ((first &0x03)<< 3) + (second >> 5);
	h3= second & 0x1f;
   
  h1= index1[h1];
	h2= index2[h2];
	h3= index3[h3];
   
  type1 = h3 ? type1_yes[h2] : type1_no[h2];
	type2 = ((h1 == 0 || h1 == 1 || h1 == 16) ? 0 : 1) + (h3 ? 2 : 0);
	type3 = _type3[h2];

	memset(ib, 0, 32);
  if(h1) memcpy(ib, HanFont1[type1][h1], 32);
	if(h2) or_image(ib, HanFont2[type2][h2], 32);
	if(h3) or_image(ib, HanFont3[type3][h3], 32);

	return ib;
}

void *get_eng_image(byte c) {
	return EngFont[c];
}

/* 32 bytes ==> 256 bytes image */
void *han_bit_image(byte *image, int fg, int bg) {
	static byte c, han_buf[256];
   int i, j, k= 0;

   for(i= 0; i< 32; i++) {
      c= *image++;
      for(j= 0; j< 8; j++) {
         if(c &0x80) 
            han_buf[k]= fg;  
         else 
            han_buf[k]= bg;
            c<<= 1;
            k++;
      }
   }
   return (void *)han_buf;
}

void *eng_bit_image(byte *image, int fg, int bg) {
   static byte c, eng_buf[128];
   int i, j, k= 0;
   
   for(i= 0; i<16; i++) {
      c= *image++;
      for(j= 0; j<8; j++) {
         if(c &0x80) 
            eng_buf[k]= fg;  
         else 
            eng_buf[k]= bg;
            c<<= 1;
            k++;
      }
   }
   return (void *)eng_buf;
}

void han_image_view(int x, int y, byte *image) {
   void *bitmap;
   
   bitmap= (void *)image;
   gl_putbox(x, y, 16, 16, bitmap);
}

void eng_image_view(int x, int y, byte *image) { 
   void *bitmap;
   
   bitmap= (void *)image;
   gl_putbox(x, y, 8, 16, bitmap);
}
