#include <stdio.h>
#include <vga.h>
#include <vgagl.h>
#include "hangul.h"
#include "hkeydef.h"

int hgetsxy(int x, int y, int fg, int bg, byte *str, int maxlen) {
	byte *curchar = str;
	int pos = 0, key, ch, result;

	hputchxy(x, y, bg, fg, ' ');
	for (;;) {
		key = hgetkey();
		if (key < 128) {
			switch (key) {
				case H_ENTER : 
				case H_ESC :
					if (tempHanState) {
						ch = inStack[inSP-1].unionCode;
						*curchar++ = ch >> 8;
						*curchar++ = ch & 0xFF;
					}
					*curchar = 0;
					return key;
				case H_BACKSPACE :
					if (pos) {
						if (tempHanState) {
							inSP--;
							if (inSP) {
								tempHanState = inStack[inSP-1].currentHanState;
								ch = inStack[inSP-1].unionCode;
							} else {
								tempHanState = inSP = outSP = 0;
								hputchxy(x+8, y, fg, bg, ' ');
								ch = ' ';
							}
							hputchxy(x, y, bg, fg, ch);	 /* reverse */
						} else {
							hputchxy(x, y, fg, bg, ' '); /* cursor delete */
							if (ishangul(str, pos -1) && pos >= 2) {
								x -= 16, pos -= 2, curchar -= 2;
						/*		hputchxy(x, y, fg, bg, ' ');   hangul delete */
								hputchxy(x+8, y, fg, bg, ' ');
							} else {
								x -= 8, pos -= 1, curchar--;
							}
							hputchxy(x, y, bg, fg, ' '); /* char delete & cursor make */
						} /* tempHanState */
					} /* pos */
					break;
				default :
					if (pos < maxlen-1) {
						if (tempHanState) {
							ch = inStack[inSP-1].unionCode;
							hputchxy(x, y, fg, bg, ch);   /* hangul original */
							x+= 16, pos+= 2;
							*curchar++ = ch >> 8;
							*curchar++ = ch & 0xFF;
							tempHanState = inSP = outSP = 0;
						}	
						hputchxy(x, y, fg, bg, key); /*  cursor delete */
						x+= 8, pos+= 1, *curchar++ = key;
						hputchxy(x, y, bg, fg, ' '); /* cursor make */
					}
					break;
			} /* if (key < 128) */
		} else if (key >= 256) {
			switch (key) {
				case H_ALT_SPACE :
					hanMode[HAN_ENG_MODE] = !hanMode[HAN_ENG_MODE];
					break;
				case H_F4 :
					hanMode[HAN_JAPAN] = !hanMode[HAN_JAPAN];
					break;
				case H_F2 :
					hanMode[HAN_CODE] = !hanMode[HAN_CODE];
					break;
			}
		} else {      /* if hangul */
			result = hanAutomata(key);
			if (result) {
				ch = inStack[inSP-1].unionCode; /* original */
				hputchxy(x, y, fg, bg, ch);
				if (pos < maxlen -2) {
					x+= 16, pos+= 2;
					*curchar++ = ch >> 8;
					*curchar++ = ch & 0xFF;
				}
				tempHanState = 0;
				inSP = 0;
				if (outSP) {
					while (outSP) hanAutomata(outStack[--outSP]);
					if (tempHanState) 
						hputchxy(x, y, bg, fg, inStack[inSP-1].unionCode); /* reverse */
				}  /* outSP */
			}	else {
				hputchxy(x, y, bg, fg, inStack[inSP-1].unionCode); /* reverse */
				}
		} 
	} /* for */
}
